/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.prefs.Preferences;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;

public class Rotator3DOFFMouse
extends JPanel
implements MouseListener,
MouseMotionListener,
MouseWheelListener,
KeyListener {
    private Objects3D obj;
    private String offFile;
    private int lastX;
    private int lastY;
    private boolean dragging = false;
    private int w;
    private int h;
    private static final double ZOOM_STEP = 0.03;
    private static final double ZOOM_STEP_FINE = 0.01;
    private static final double DOLLY_STEP = 0.12;
    private static final double DOLLY_STEP_FINE = 0.04;
    boolean depthSortEnabled = true;
    private final Preferences prefs = Preferences.userNodeForPackage(Rotator3DOFFMouse.class);
    private static final String PREF_LAST_DIR = "lastOpenDir";

    public Rotator3DOFFMouse(String string) {
        File file;
        File file2;
        this.offFile = string;
        this.setBackground(Color.white);
        this.setDoubleBuffered(true);
        this.setPreferredSize(new Dimension(1000, 800));
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.setFocusable(true);
        this.addKeyListener(this);
        if (this.offFile != null && (file2 = (file = new File(this.offFile)).getParentFile()) != null && file2.isDirectory()) {
            this.prefs.put(PREF_LAST_DIR, file2.getAbsolutePath());
        }
    }

    public void loadFile(String string) {
        this.offFile = string;
        try {
            this.obj = null;
            this.rememberChosenFile(new File(string));
            this.repaint();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, "Failed to load OFF file:\n" + exception.getMessage(), "Load Error", 0);
        }
    }

    public void setDepthSortEnabled(boolean bl) {
        this.depthSortEnabled = bl;
        if (this.obj != null) {
            this.obj.setDepthSortEnabled(bl);
            this.repaint();
        }
    }

    public void resetView() {
        if (this.obj != null) {
            this.obj.resetView();
            this.obj.CalcScrPts((double)this.getWidth() / 2.0, (double)this.getHeight() / 2.0);
            this.repaint();
        }
    }

    private File getInitialDirForChooser() {
        File file;
        File file2;
        String string = this.prefs.get(PREF_LAST_DIR, null);
        if (string != null && (file2 = new File(string)).isDirectory()) {
            return file2;
        }
        if (this.offFile != null && (file = (file2 = new File(this.offFile)).getParentFile()) != null && file.isDirectory()) {
            return file;
        }
        file2 = new File(System.getProperty("user.home"));
        if (file2.isDirectory()) {
            return file2;
        }
        return new File(System.getProperty("user.dir"));
    }

    private void rememberChosenFile(File file) {
        File file2;
        if (file != null && (file2 = file.getParentFile()) != null && file2.isDirectory()) {
            this.prefs.put(PREF_LAST_DIR, file2.getAbsolutePath());
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.w = this.getWidth();
        this.h = this.getHeight();
        if (this.obj == null && this.offFile != null) {
            this.obj = new Objects3D(this.offFile, (double)this.w / 2.0, (double)this.h / 2.0, Math.min(this.w, this.h));
            this.obj.setDepthSortEnabled(this.depthSortEnabled);
            this.obj.CalcScrPts((double)this.w / 2.0, (double)this.h / 2.0);
            this.requestFocusInWindow();
        }
        if (this.obj != null) {
            this.obj.render(graphics2D);
        }
        graphics2D.dispose();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.dragging = true;
            this.lastX = mouseEvent.getX();
            this.lastY = mouseEvent.getY();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.dragging = false;
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.dragging || this.obj == null) {
            return;
        }
        int n = mouseEvent.getX() - this.lastX;
        int n2 = mouseEvent.getY() - this.lastY;
        this.obj.applyDragRotation(n, n2);
        this.lastX = mouseEvent.getX();
        this.lastY = mouseEvent.getY();
        this.repaint();
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (this.obj == null) {
            return;
        }
        double d = mouseWheelEvent.getPreciseWheelRotation();
        boolean bl = mouseWheelEvent.isShiftDown();
        boolean bl2 = mouseWheelEvent.isControlDown();
        if (this.obj.invertWheel) {
            d = -d;
        }
        if (bl2) {
            double d2 = bl ? 0.04 : 0.12;
            this.obj.dolly(d, d2);
        } else {
            double d3 = bl ? 0.01 : 0.03;
            double d4 = Math.pow(1.0 + d3, -d);
            this.obj.zoomScaleOnly(d4);
        }
        this.obj.CalcScrPts((double)this.w / 2.0, (double)this.h / 2.0);
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (SwingUtilities.isRightMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2 && this.obj != null) {
            this.resetView();
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (this.obj == null) {
            return;
        }
        switch (keyEvent.getKeyCode()) {
            case 82: {
                this.resetView();
                break;
            }
            case 72: {
                this.obj.invertWheel = !this.obj.invertWheel;
                System.out.println("Invert wheel: " + (this.obj.invertWheel ? "ON" : "OFF"));
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    private static JMenuBar buildMenuBar(JFrame jFrame, Rotator3DOFFMouse rotator3DOFFMouse) {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        JMenuItem jMenuItem = new JMenuItem("Open\u2026");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()));
        jMenuItem.addActionListener(actionEvent -> {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setDialogTitle("Open OFF file");
            jFileChooser.setFileFilter(new FileNameExtensionFilter("OFF files", "off", "txt"));
            File file = rotator3DOFFMouse.getInitialDirForChooser();
            jFileChooser.setCurrentDirectory(file);
            int n = jFileChooser.showOpenDialog(jFrame);
            if (n == 0) {
                File file2 = jFileChooser.getSelectedFile();
                rotator3DOFFMouse.rememberChosenFile(file2);
                rotator3DOFFMouse.loadFile(file2.getAbsolutePath());
            }
        });
        JMenuItem jMenuItem2 = new JMenuItem("Reset View");
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(82, 0));
        jMenuItem2.addActionListener(actionEvent -> rotator3DOFFMouse.resetView());
        JMenuItem jMenuItem3 = new JMenuItem("Exit");
        jMenuItem3.setAccelerator(KeyStroke.getKeyStroke(81, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()));
        jMenuItem3.addActionListener(actionEvent -> jFrame.dispose());
        jMenu.add(jMenuItem);
        jMenu.add(jMenuItem2);
        jMenu.addSeparator();
        jMenu.add(jMenuItem3);
        JMenu jMenu2 = new JMenu("View");
        JMenuItem jMenuItem4 = new JMenuItem("Toggle Depth Sorting");
        jMenuItem4.setAccelerator(KeyStroke.getKeyStroke(68, 0));
        jMenuItem4.addActionListener(actionEvent -> rotator3DOFFMouse.setDepthSortEnabled(!rotator3DOFFMouse.depthSortEnabled));
        JMenuItem jMenuItem5 = new JMenuItem("Invert Wheel");
        jMenuItem5.setAccelerator(KeyStroke.getKeyStroke(72, 0));
        jMenuItem5.addActionListener(actionEvent -> {
            if (rotator3DOFFMouse.obj != null) {
                rotator3DOFFMouse.obj.invertWheel = !rotator3DOFFMouse.obj.invertWheel;
                rotator3DOFFMouse.repaint();
            }
        });
        JMenu jMenu3 = new JMenu("Color Scheme");
        JMenuItem jMenuItem6 = new JMenuItem("Lighting (Lambert)");
        jMenuItem6.addActionListener(actionEvent -> {
            if (rotator3DOFFMouse.obj != null) {
                rotator3DOFFMouse.obj.setColourScheme(Objects3D.ColourScheme.LIGHTING);
                rotator3DOFFMouse.repaint();
            }
        });
        JMenuItem jMenuItem7 = new JMenuItem("Rainbow");
        jMenuItem7.addActionListener(actionEvent -> {
            if (rotator3DOFFMouse.obj != null) {
                rotator3DOFFMouse.obj.setColourScheme(Objects3D.ColourScheme.RAINBOW);
                rotator3DOFFMouse.repaint();
            }
        });
        JMenuItem jMenuItem8 = new JMenuItem("Viridis-like");
        jMenuItem8.addActionListener(actionEvent -> {
            if (rotator3DOFFMouse.obj != null) {
                rotator3DOFFMouse.obj.setColourScheme(Objects3D.ColourScheme.VIRIDIS);
                rotator3DOFFMouse.repaint();
            }
        });
        JMenuItem jMenuItem9 = new JMenuItem("Heat");
        jMenuItem9.addActionListener(actionEvent -> {
            if (rotator3DOFFMouse.obj != null) {
                rotator3DOFFMouse.obj.setColourScheme(Objects3D.ColourScheme.HEAT);
                rotator3DOFFMouse.repaint();
            }
        });
        JMenuItem jMenuItem10 = new JMenuItem("Depth-based");
        jMenuItem10.addActionListener(actionEvent -> {
            if (rotator3DOFFMouse.obj != null) {
                rotator3DOFFMouse.obj.setColourScheme(Objects3D.ColourScheme.DEPTH);
                rotator3DOFFMouse.repaint();
            }
        });
        jMenu3.add(jMenuItem6);
        jMenu3.add(jMenuItem7);
        jMenu3.add(jMenuItem8);
        jMenu3.add(jMenuItem9);
        jMenu3.add(jMenuItem10);
        jMenu2.add(jMenuItem4);
        jMenu2.add(jMenuItem5);
        jMenu2.add(jMenu3);
        JMenu jMenu4 = new JMenu("Help");
        JMenuItem jMenuItem11 = new JMenuItem("Controls\u2026");
        jMenuItem11.addActionListener(actionEvent -> JOptionPane.showMessageDialog(jFrame, "Controls:\n\nLeft\u2011drag: tumble (yaw/pitch)\nMouse wheel: zoom (scale)\nCtrl + wheel: dolly (move along Z)\nShift: fine step for wheel\nRight\u2011button double\u2011click: Reset view\nKeys: R reset, H invert wheel, D toggle depth sorting\nMenu: View \u2192 Color Scheme for palette switching", "Controls", 1));
        jMenu4.add(jMenuItem11);
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu2);
        jMenuBar.add(jMenu4);
        return jMenuBar;
    }

    public static void main(String[] stringArray) {
        String string = stringArray.length >= 1 ? stringArray[0] : null;
        SwingUtilities.invokeLater(() -> {
            JFrame jFrame = new JFrame("POGO 3D Rotator - durnan.org OFF Viewer");
            jFrame.setDefaultCloseOperation(3);
            Rotator3DOFFMouse rotator3DOFFMouse = new Rotator3DOFFMouse(string);
            jFrame.setJMenuBar(Rotator3DOFFMouse.buildMenuBar(jFrame, rotator3DOFFMouse));
            jFrame.add(rotator3DOFFMouse);
            jFrame.pack();
            jFrame.setSize(1000, 800);
            jFrame.setLocationRelativeTo(null);
            jFrame.setVisible(true);
        });
    }

    private static class Objects3D {
        private int[][] polygons;
        private int npoly;
        private double[][] points;
        private int npoint;
        private int[][] faces;
        private int nface;
        private final int ncolour = 10;
        private final Color[][] colours = new Color[10][7];
        private double[] lightvec = new double[]{0.0, 1.0, 1.0};
        private final double Zeye = 10.0;
        private final Matrix3D orient = new Matrix3D();
        private final Matrix3D tmp = new Matrix3D();
        private final Matrix3D tmp2 = new Matrix3D();
        private double scale;
        private double modelZ;
        private double baseScale;
        private double baseModelZ;
        private double maxRadius;
        private double[][] rotPts;
        private int[][] scrPts;
        private int[] xx = new int[4096];
        private int[] yy = new int[4096];
        private final double cx;
        private final double cy;
        private final double panelMin;
        private int p;
        private double MIN_SCALE;
        private double MAX_SCALE;
        private double MIN_MODELZ;
        private double MAX_MODELZ;
        boolean invertWheel = false;
        private boolean depthSortEnabled = true;
        private ColourScheme colourScheme = ColourScheme.LIGHTING;
        private static final Color[] VIRIDIS_STOPS = new Color[]{new Color(68, 1, 84), new Color(59, 82, 139), new Color(33, 144, 141), new Color(94, 201, 98), new Color(253, 231, 37)};
        private static final Color[] HEAT_STOPS = new Color[]{new Color(0, 0, 0), new Color(128, 0, 0), new Color(255, 0, 0), new Color(255, 165, 0), new Color(255, 255, 0), new Color(255, 255, 255)};

        public Objects3D(String string, double d, double d2, double d3) {
            double d4;
            int n;
            this.cx = d;
            this.cy = d2;
            this.panelMin = d3;
            this.loadFromOFF(string);
            this.rotPts = new double[this.npoint][3];
            this.scrPts = new int[this.npoint][2];
            for (int i = 0; i < 10; ++i) {
                int n2 = 255 - (9 - i) * 100 / 10;
                this.colours[i][0] = new Color(n2, n2, n2);
                this.colours[i][1] = new Color(n2, 0, 0);
                this.colours[i][2] = new Color(0, n2, 0);
                this.colours[i][3] = new Color(0, 0, n2);
                this.colours[i][4] = new Color(n2, n2, 0);
                this.colours[i][5] = new Color(0, n2, n2);
                this.colours[i][6] = new Color(n2, 0, n2);
            }
            double d5 = Math.sqrt(this.lightvec[0] * this.lightvec[0] + this.lightvec[1] * this.lightvec[1] + this.lightvec[2] * this.lightvec[2]);
            if (d5 > 0.0) {
                this.lightvec[0] = this.lightvec[0] / d5;
                this.lightvec[1] = this.lightvec[1] / d5;
                this.lightvec[2] = this.lightvec[2] / d5;
            }
            this.recenterToCentroid();
            this.computeFaceNormals();
            for (n = 0; n < this.nface; ++n) {
                d4 = Math.sqrt(this.points[n][0] * this.points[n][0] + this.points[n][1] * this.points[n][1] + this.points[n][2] * this.points[n][2]);
                if (!(d4 > 0.0)) continue;
                double[] dArray = this.points[n];
                dArray[0] = dArray[0] / d4;
                double[] dArray2 = this.points[n];
                dArray2[1] = dArray2[1] / d4;
                double[] dArray3 = this.points[n];
                dArray3[2] = dArray3[2] / d4;
            }
            this.maxRadius = 0.0;
            for (n = this.nface; n < this.npoint; ++n) {
                d4 = Math.sqrt(this.points[n][0] * this.points[n][0] + this.points[n][1] * this.points[n][1] + this.points[n][2] * this.points[n][2]);
                if (!(d4 > this.maxRadius)) continue;
                this.maxRadius = d4;
            }
            this.baseScale = d3 * 0.4 / Math.max(1.0E-6, this.maxRadius);
            this.baseModelZ = -2.0 * this.maxRadius;
            this.scale = this.baseScale;
            this.modelZ = this.baseModelZ;
            this.MIN_SCALE = this.baseScale * 0.15;
            this.MAX_SCALE = this.baseScale * 6.0;
            this.MIN_MODELZ = -0.25 * this.maxRadius;
            this.MAX_MODELZ = -10.0 * this.maxRadius;
        }

        public void setDepthSortEnabled(boolean bl) {
            this.depthSortEnabled = bl;
        }

        public void setColourScheme(ColourScheme colourScheme) {
            this.colourScheme = colourScheme;
        }

        private void loadFromOFF(String string) {
            int n;
            int n2;
            Object object;
            ArrayList<double[]> arrayList = new ArrayList<double[]>();
            ArrayList<int[]> arrayList2 = new ArrayList<int[]>();
            try (BufferedReader bufferedReader = new BufferedReader(new FileReader(string));){
                String[] stringArray;
                while ((object = bufferedReader.readLine()) != null && (((String)(object = ((String)object).trim())).isEmpty() || ((String)object).startsWith("#") || !((String)object).equalsIgnoreCase("OFF"))) {
                }
                if (object == null) {
                    throw new IOException("OFF header not found");
                }
                int n3 = 0;
                n2 = 0;
                while ((object = bufferedReader.readLine()) != null) {
                    if (((String)(object = ((String)object).trim())).isEmpty() || ((String)object).startsWith("#")) continue;
                    stringArray = ((String)object).split("\\s+");
                    if (stringArray.length < 2) {
                        throw new IOException("Counts line incomplete");
                    }
                    n3 = Integer.parseInt(stringArray[0]);
                    n2 = Integer.parseInt(stringArray[1]);
                    break;
                }
                while (arrayList.size() < n3 && (object = bufferedReader.readLine()) != null) {
                    if (((String)(object = ((String)object).trim())).isEmpty() || ((String)object).startsWith("#") || (stringArray = ((String)object).split("\\s+")).length < 3) continue;
                    try {
                        double d = Double.parseDouble(stringArray[0]);
                        double d2 = Double.parseDouble(stringArray[1]);
                        double d3 = Double.parseDouble(stringArray[2]);
                        arrayList.add(new double[]{d, d2, d3});
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                int n4 = 0;
                while (n4 < n2 && (object = bufferedReader.readLine()) != null) {
                    if (((String)(object = ((String)object).trim())).isEmpty() || ((String)object).startsWith("#")) continue;
                    String[] stringArray2 = ((String)object).split("\\s+");
                    try {
                        int n5 = Integer.parseInt(stringArray2[0]);
                        if (n5 < 3) {
                            ++n4;
                            continue;
                        }
                        int[] nArray = new int[n5];
                        int n6 = 0;
                        for (int i = 1; i < stringArray2.length && n6 < n5; ++i) {
                            try {
                                nArray[n6] = Integer.parseInt(stringArray2[i]);
                                ++n6;
                                continue;
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        if (n6 == n5) {
                            arrayList2.add(nArray);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    ++n4;
                }
            }
            catch (Exception exception) {
                System.err.println("Error loading OFF file: " + exception.getMessage());
                System.exit(1);
            }
            this.npoly = this.nface = arrayList2.size();
            this.npoint = this.nface + arrayList.size();
            this.points = new double[this.npoint][3];
            this.polygons = new int[this.npoly][];
            this.faces = new int[this.nface][];
            for (n = 0; n < arrayList.size(); ++n) {
                object = (double[])arrayList.get(n);
                this.points[this.nface + n][0] = (double)object[0];
                this.points[this.nface + n][1] = (double)object[1];
                this.points[this.nface + n][2] = (double)object[2];
            }
            for (n = 0; n < this.nface; ++n) {
                object = (int[])arrayList2.get(n);
                int[] nArray = new int[((Object)object).length + 2];
                nArray[0] = ((Object)object).length;
                nArray[1] = n % 6 + 1;
                for (n2 = 0; n2 < ((Object)object).length; ++n2) {
                    nArray[n2 + 2] = (int)(object[n2] + this.nface);
                }
                this.polygons[n] = nArray;
                this.faces[n] = new int[]{1, n};
            }
        }

        private void recenterToCentroid() {
            int n;
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            int n2 = this.npoint - this.nface;
            for (n = this.nface; n < this.npoint; ++n) {
                d += this.points[n][0];
                d2 += this.points[n][1];
                d3 += this.points[n][2];
            }
            if (n2 > 0) {
                d /= (double)n2;
                d2 /= (double)n2;
                d3 /= (double)n2;
            }
            for (n = this.nface; n < this.npoint; ++n) {
                double[] dArray = this.points[n];
                dArray[0] = dArray[0] - d;
                double[] dArray2 = this.points[n];
                dArray2[1] = dArray2[1] - d2;
                double[] dArray3 = this.points[n];
                dArray3[2] = dArray3[2] - d3;
            }
        }

        private void computeFaceNormals() {
            for (int i = 0; i < this.nface; ++i) {
                int n = this.polygons[i][0];
                if (n < 3) {
                    this.points[i][2] = 0.0;
                    this.points[i][1] = 0.0;
                    this.points[i][0] = 0.0;
                    continue;
                }
                int n2 = this.polygons[i][2];
                int n3 = this.polygons[i][3];
                int n4 = this.polygons[i][4];
                double[] dArray = new double[]{this.points[n3][0] - this.points[n2][0], this.points[n3][1] - this.points[n2][1], this.points[n3][2] - this.points[n2][2]};
                double[] dArray2 = new double[]{this.points[n4][0] - this.points[n2][0], this.points[n4][1] - this.points[n2][1], this.points[n4][2] - this.points[n2][2]};
                this.points[i][0] = dArray[1] * dArray2[2] - dArray[2] * dArray2[1];
                this.points[i][1] = dArray[2] * dArray2[0] - dArray[0] * dArray2[2];
                this.points[i][2] = dArray[0] * dArray2[1] - dArray[1] * dArray2[0];
            }
        }

        private static Color lerp(Color color, Color color2, double d) {
            d = Math.max(0.0, Math.min(1.0, d));
            int n = (int)Math.round((double)color.getRed() + (double)(color2.getRed() - color.getRed()) * d);
            int n2 = (int)Math.round((double)color.getGreen() + (double)(color2.getGreen() - color.getGreen()) * d);
            int n3 = (int)Math.round((double)color.getBlue() + (double)(color2.getBlue() - color.getBlue()) * d);
            return new Color(n, n2, n3);
        }

        private static Color gradient(Color[] colorArray, double d) {
            d = Math.max(0.0, Math.min(1.0, d));
            int n = colorArray.length;
            if (n == 0) {
                return Color.GRAY;
            }
            if (n == 1) {
                return colorArray[0];
            }
            double d2 = d * (double)(n - 1);
            int n2 = (int)Math.floor(d2);
            double d3 = d2 - (double)n2;
            if (n2 >= n - 1) {
                return colorArray[n - 1];
            }
            return Objects3D.lerp(colorArray[n2], colorArray[n2 + 1], d3);
        }

        private static Color rainbow(double d) {
            d = Math.max(0.0, Math.min(1.0, d));
            return Color.getHSBColor((float)d, 1.0f, 1.0f);
        }

        private double computeScalarForFace(int n) {
            switch (this.colourScheme.ordinal()) {
                case 0: {
                    double d = this.rotPts[n][0] * this.lightvec[0] + this.rotPts[n][1] * this.lightvec[1] + this.rotPts[n][2] * this.lightvec[2];
                    return Math.max(0.0, Math.min(1.0, (d + 1.0) * 0.5));
                }
                case 4: {
                    double d = this.avgDepthOfPoly(this.faces[n][1]);
                    double d2 = -0.5 * this.maxRadius;
                    double d3 = -8.0 * this.maxRadius;
                    double d4 = (d - d3) / Math.max(1.0E-6, d2 - d3);
                    return Math.max(0.0, Math.min(1.0, d4));
                }
                case 1: 
                case 2: 
                case 3: {
                    double d;
                    int n2 = this.faces[n][1];
                    int n3 = this.polygons[n2][0];
                    double d5 = 0.0;
                    for (int i = 0; i < n3; ++i) {
                        int n4 = this.polygons[n2][i + 2];
                        d = this.points[n4][0];
                        double d6 = this.points[n4][1];
                        double d7 = this.points[n4][2];
                        d5 += Math.sqrt(d * d + d6 * d6 + d7 * d7);
                    }
                    double d8 = n3 > 0 ? d5 / (double)n3 : 0.0;
                    d = d8 / Math.max(1.0E-6, this.maxRadius);
                    return Math.max(0.0, Math.min(1.0, d));
                }
            }
            return 0.5;
        }

        private Color colorFromScalar(double d, int n) {
            switch (this.colourScheme.ordinal()) {
                case 0: {
                    int n2 = Math.max(0, Math.min(9, (int)Math.round(d * 9.0)));
                    return this.colours[n2][n];
                }
                case 1: {
                    return Objects3D.rainbow(d);
                }
                case 2: {
                    return Objects3D.gradient(VIRIDIS_STOPS, d);
                }
                case 3: {
                    return Objects3D.gradient(HEAT_STOPS, d);
                }
                case 4: {
                    return Objects3D.rainbow(d);
                }
            }
            return Color.GRAY;
        }

        private Color getColour(int n, int n2) {
            int n3 = this.polygons[this.faces[n][n2]][1];
            double d = this.computeScalarForFace(n);
            return this.colorFromScalar(d, n3);
        }

        public void CalcScrPts(double d, double d2) {
            this.p = 0;
            while (this.p < this.npoint) {
                this.rotPts[this.p][2] = this.points[this.p][0] * this.orient.M[2][0] + this.points[this.p][1] * this.orient.M[2][1] + this.points[this.p][2] * this.orient.M[2][2];
                this.rotPts[this.p][0] = this.points[this.p][0] * this.orient.M[0][0] + this.points[this.p][1] * this.orient.M[0][1] + this.points[this.p][2] * this.orient.M[0][2];
                this.rotPts[this.p][1] = -this.points[this.p][0] * this.orient.M[1][0] - this.points[this.p][1] * this.orient.M[1][1] - this.points[this.p][2] * this.orient.M[1][2];
                ++this.p;
            }
            this.p = this.nface;
            while (this.p < this.npoint) {
                double d3 = this.rotPts[this.p][2] + this.modelZ;
                double d4 = (10.0 - d3) / (this.scale * 10.0);
                if (Math.abs(d4) < 1.0E-6) {
                    d4 = d4 < 0.0 ? -1.0E-6 : 1.0E-6;
                }
                this.scrPts[this.p][0] = (int)(this.rotPts[this.p][0] / d4 + d);
                this.scrPts[this.p][1] = (int)(this.rotPts[this.p][1] / d4 + d2);
                ++this.p;
            }
        }

        private boolean faceUp(int n) {
            int n2 = this.polygons[n][2];
            double d = this.rotPts[n2][0];
            double d2 = this.rotPts[n2][1];
            double d3 = this.rotPts[n2][2] + this.modelZ;
            double d4 = this.rotPts[n][0] * d + this.rotPts[n][1] * d2 + this.rotPts[n][2] * (d3 - 10.0);
            return d4 < 0.0;
        }

        public void zoomScaleOnly(double d) {
            if (!(d > 0.0)) {
                return;
            }
            this.scale *= d;
            if (this.scale < this.MIN_SCALE) {
                this.scale = this.MIN_SCALE;
            }
            if (this.scale > this.MAX_SCALE) {
                this.scale = this.MAX_SCALE;
            }
        }

        public void dolly(double d, double d2) {
            double d3 = -d * d2 * this.maxRadius;
            this.modelZ += d3;
            if (this.modelZ > this.MIN_MODELZ) {
                this.modelZ = this.MIN_MODELZ;
            }
            if (this.modelZ < this.MAX_MODELZ) {
                this.modelZ = this.MAX_MODELZ;
            }
        }

        public void resetView() {
            this.scale = this.baseScale;
            this.modelZ = this.baseModelZ;
        }

        public void applyDragRotation(int n, int n2) {
            double d = 0.018;
            double d2 = (double)n * d;
            double d3 = (double)(-n2) * d;
            this.tmp.Rotation(2, 0, d2);
            this.tmp2.Rotation(1, 2, d3);
            double[][] dArray = this.tmp2.multiply(this.tmp.M);
            this.orient.multiplyRightInPlace(dArray);
            this.CalcScrPts(this.cx, this.cy);
        }

        private double avgDepthOfPoly(int n) {
            int n2 = this.polygons[n][0];
            double d = 0.0;
            for (int i = 0; i < n2; ++i) {
                int n3 = this.polygons[n][i + 2];
                d += this.rotPts[n3][2] + this.modelZ;
            }
            return n2 > 0 ? d / (double)n2 : 0.0;
        }

        public void render(Graphics2D graphics2D) {
            double d;
            Color color;
            int n;
            int n2;
            int n3;
            if (!this.depthSortEnabled) {
                int n4;
                int n5;
                int n6 = 0;
                for (n5 = 0; n5 < this.nface; ++n5) {
                    if (!this.faceUp(n5)) continue;
                    for (n4 = 1; n4 < this.faces[n5][0] + 1; ++n4) {
                        this.DrawPoly(graphics2D, this.faces[n5][n4], this.getColour(n5, n4));
                    }
                    ++n6;
                }
                if (n6 == 0) {
                    for (n5 = 0; n5 < this.nface; ++n5) {
                        for (n4 = 1; n4 < this.faces[n5][0] + 1; ++n4) {
                            this.DrawPoly(graphics2D, this.faces[n5][n4], this.getColour(n5, n4));
                        }
                    }
                }
                return;
            }
            class DrawItem {
                int polyIndex;
                Color colour;
                double depth;

                DrawItem(Objects3D objects3D, int n, Color color, double d) {
                    Objects.requireNonNull(objects3D);
                    this.polyIndex = n;
                    this.colour = color;
                    this.depth = d;
                }
            }
            ArrayList<DrawItem> arrayList = new ArrayList<DrawItem>();
            for (n3 = 0; n3 < this.nface; ++n3) {
                if (!this.faceUp(n3)) continue;
                for (n2 = 1; n2 < this.faces[n3][0] + 1; ++n2) {
                    n = this.faces[n3][n2];
                    color = this.getColour(n3, n2);
                    d = this.avgDepthOfPoly(n);
                    arrayList.add(new DrawItem(this, n, color, d));
                }
            }
            if (arrayList.isEmpty()) {
                for (n3 = 0; n3 < this.nface; ++n3) {
                    for (n2 = 1; n2 < this.faces[n3][0] + 1; ++n2) {
                        n = this.faces[n3][n2];
                        color = this.getColour(n3, n2);
                        d = this.avgDepthOfPoly(n);
                        arrayList.add(new DrawItem(this, n, color, d));
                    }
                }
            }
            arrayList.sort((drawItem, drawItem2) -> Double.compare(drawItem.depth, drawItem2.depth));
            for (DrawItem drawItem3 : arrayList) {
                this.DrawPoly(graphics2D, drawItem3.polyIndex, drawItem3.colour);
            }
        }

        private void DrawPoly(Graphics2D graphics2D, int n, Color color) {
            int n2 = this.polygons[n][0];
            if (n2 <= 0 || n2 > this.xx.length) {
                return;
            }
            for (int i = 0; i < n2; ++i) {
                int n3 = this.polygons[n][i + 2];
                this.xx[i] = this.scrPts[n3][0];
                this.yy[i] = this.scrPts[n3][1];
            }
            graphics2D.setColor(color);
            graphics2D.fillPolygon(this.xx, this.yy, n2);
            graphics2D.setColor(new Color(0, 0, 0, 60));
            graphics2D.drawPolygon(this.xx, this.yy, n2);
        }

        private static enum ColourScheme {
            LIGHTING,
            RAINBOW,
            VIRIDIS,
            HEAT,
            DEPTH;

        }
    }

    private static class Matrix3D {
        public double[][] M = new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}};

        private Matrix3D() {
        }

        public void Rotation(int n, int n2, double d) {
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    this.M[i][j] = i == j ? 1.0 : 0.0;
                }
            }
            double d2 = Math.cos(d);
            double d3 = Math.sin(d);
            this.M[n][n] = d2;
            this.M[n2][n2] = d2;
            this.M[n][n2] = d3;
            this.M[n2][n] = -d3;
        }

        public double[][] multiply(double[][] dArray) {
            double[][] dArray2 = new double[3][3];
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    double d = 0.0;
                    for (int k = 0; k < 3; ++k) {
                        d += this.M[i][k] * dArray[k][j];
                    }
                    dArray2[i][j] = d;
                }
            }
            return dArray2;
        }

        public void multiplyRightInPlace(double[][] dArray) {
            this.M = this.multiply(dArray);
        }
    }
}

